unit MeetingManagerEcoSpace;

interface

uses
  Borland.Eco.Services,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.Handles,
  CoreClassesUnit, 
  Borland.Eco.Persistence.Configuration, 
  Borland.Eco.Persistence, Borland.Data.Provider;

type
  [EcoSpace]
  [EcoSpacePackage(TypeOf(CoreClassesUnit.CoreClasses))]
  
  TMeetingManagerEcoSpace = class(Borland.Eco.Handles.DefaultEcoSpace)
  strict private
    PersistenceMapperXml1: Borland.Eco.Persistence.PersistenceMapperXml;
    procedure InitializeComponent;
  private
    class var typeSystemProvider: ITypeSystemService;
  strict protected
    function GetTypeSystemProvider: ITypeSystemService; override;
  public
    constructor Create;
    class function GetTypeSystemService: ITypeSystemService; static;
    procedure UpdateDatabase;
    function get_PersistenceService: IPersistenceService;
    property PersistenceService: IPersistenceService read get_PersistenceService;
    function get_DirtyListService: IDirtyListService;
    property DirtyListService: IDirtyListService read get_DirtyListService;
    function get_UndoService: IUndoService;
    property UndoService: IUndoService read get_UndoService;
    function get_TypeSystemService: ITypeSystemService;
    property TypeSystemService: ITypeSystemService read get_TypeSystemService;
    function get_OclService: IOclService;
    property OclService: IOclService read get_OclService;
    function get_ObjectFactoryService: IObjectFactoryService;
    property ObjectFactoryService: IObjectFactoryService read get_ObjectFactoryService;
    function get_VariableFactoryService: IVariableFactoryService;
    property VariableFactoryService: IVariableFactoryService read get_VariableFactoryService;
  end;

implementation

constructor TMeetingManagerEcoSpace.Create;
begin
  inherited Create;
  InitializeComponent;
  // TODO: Add any constructor code here
end;

class function TMeetingManagerEcoSpace.GetTypeSystemService: ITypeSystemService;
begin
  if not Assigned(typeSystemProvider) then
    typeSystemProvider := MakeTypeService(typeOf(TMeetingManagerEcoSpace));
  Result := typeSystemProvider;
end;

function TMeetingManagerEcoSpace.GetTypeSystemProvider: ITypeSystemService;
begin
  Result := TMeetingManagerEcoSpace.GetTypeSystemService;
end;

procedure TMeetingManagerEcoSpace.UpdateDatabase;
begin
  if Assigned(PersistenceService) and Assigned(DirtyListService) then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

function TMeetingManagerEcoSpace.get_PersistenceService: IPersistenceService;
begin
  Result := GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
end;

function TMeetingManagerEcoSpace.get_DirtyListService: IDirtyListService;
begin
  Result := GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
end;

function TMeetingManagerEcoSpace.get_UndoService: IUndoService;
begin
  Result := GetEcoService(typeof(IUndoService)) as IUndoService;
end;

function TMeetingManagerEcoSpace.get_TypeSystemService: ITypeSystemService;
begin
  Result := GetEcoService(typeof(ITypeSystemService)) as ITypeSystemService;
end;

function TMeetingManagerEcoSpace.get_OclService: IOclService;
begin
  Result := GetEcoService(typeof(IOclService)) as IOclService;
end;

function TMeetingManagerEcoSpace.get_ObjectFactoryService: IObjectFactoryService;
begin
  Result := GetEcoService(typeof(IObjectFactoryService)) as IObjectFactoryService;
end;

function TMeetingManagerEcoSpace.get_VariableFactoryService: IVariableFactoryService;
begin
  Result := GetEcoService(typeof(IVariableFactoryService)) as IVariableFactoryService;
end;

procedure TMeetingManagerEcoSpace.InitializeComponent;
begin
  Self.PersistenceMapperXml1 := Borland.Eco.Persistence.PersistenceMapperXml.Create;
  // 
  // PersistenceMapperXml1
  // 
  Self.PersistenceMapperXml1.CacheData := False;
  Self.PersistenceMapperXml1.FileName := 'MeetingManager.Data';
  // 
  // TMeetingManagerEcoSpace
  // 
  Self.PersistenceMapper := Self.PersistenceMapperXml1;
end;

end.
